package com.vf106.tools.activity;

import android.annotation.SuppressLint;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.ScrollView;
import android.widget.TextView;

import androidx.appcompat.app.AppCompatActivity;

import com.kongqw.serialportlibrary.SerialPortManager;
import com.kongqw.serialportlibrary.listener.OnSerialPortDataListener;
import com.kongqw.serialportlibrary.utils.ByteUtils;
import com.vf106.tools.R;
import com.vf106.tools.activity.base.BaseActivity;
import com.vf106.tools.utils.Constants;

import java.io.File;
import java.nio.charset.StandardCharsets;

public class Rs232Activity extends BaseActivity implements View.OnClickListener {
    private TextView tv;
    private ScrollView tvSv;
    private SerialPortManager mSerialPortManager;
    private String viewData = "";
    private String viewDataCr = "";
    private long lastRecvTime = 0;
    private EditText et_content;
    private Button btnSend;
    private LinearLayout llRight;
    private LinearLayout llWrong;
    private int position;
    private int state;
    private String name;

    @Override
    protected void setContentView() {
        setContentView(R.layout.activity_485);
    }

    @Override
    protected void initViews() {
        Intent intent = getIntent();
        position = intent.getIntExtra("position", 0);
        name = intent.getStringExtra("name");
        state = intent.getIntExtra("state", 0);
        llRight = findViewById(R.id.ll_right);
        llWrong = findViewById(R.id.ll_wrong);
        tv = findViewById(R.id.tv);
        tvSv = findViewById(R.id.tvSv);
        et_content = findViewById(R.id.et_content);
        btnSend = findViewById(R.id.btn_send);

        mSerialPortManager = new SerialPortManager();
        setPortListener();
        //Open the serial port
        boolean openSerialPort = mSerialPortManager.openSerialPort(new File("/dev/ttyS5"), 115200);
        Log.i("openSerialPort", "openSerialPort： " + openSerialPort);
        mSerialPortManager.startReadThread(485);
        mSerialPortManager.startSendThread();
    }

    @Override
    protected void setTitle() {
        setActionBarTitle("RS232 function test");
    }

    @Override
    protected void setListener() {
        btnSend.setOnClickListener(v -> {
            String text = et_content.getText().toString();
            viewData = (viewDataCr + "dispatch:" + text + "\n");
            viewDataCr = "";
            mSerialPortManager.sendBytes(ByteUtils.hexStr2Bytes(text));
            tv.append(viewData);
            tvSv.fullScroll(ScrollView.FOCUS_DOWN);
        });

        llRight.setOnClickListener(this);
        llWrong.setOnClickListener(this);
    }

    @Override
    protected void initViewData() {

    }

    private void setPortListener() {
        mSerialPortManager.setOnSerialPortDataListener(new OnSerialPortDataListener() {
            @Override
            public void onDataReceived(byte[] bytes) {
                long timeInterval = (System.nanoTime() - lastRecvTime) / 1000000;
                lastRecvTime = System.nanoTime();
                String data = ByteUtils.bytesToHexString(bytes);
                Log.i("SerialPortDataListener", data);
                if (timeInterval > 30) {
                    viewData = (viewDataCr + "reception:" + data + "\n");
                    viewDataCr = "";
                } else {
                    viewData = data;
                    viewDataCr = "\n";
                }
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        tv.append(viewData);
                        tvSv.fullScroll(ScrollView.FOCUS_DOWN);
                    }
                });
            }

            @Override
            public void onDataSent(byte[] bytes) {
                Log.i("SerialPortDataListener", "onDataSent:" + new String(bytes));
            }
        });
    }

    @SuppressLint("NonConstantResourceId")
    @Override
    public void onClick(View v) {
        switch (v.getId()) {
            case R.id.ll_right:
                state = 1;
                setIntentData();
                break;
            case R.id.ll_wrong:
                state = 2;
                setIntentData();
                break;
        }
    }

    public void setIntentData() {
        Intent intent = new Intent();
        intent.putExtra("name", name);
        intent.putExtra("state", state);
        intent.putExtra("position", position);
        setResult(Constants.resultCode, intent);
        finish();
    }
}
